import { normalizeDates } from "./_lib/normalizeDates.js";

import { getMonth as coreGetMonth } from "./_core/getMonth.js";
import { getFullYear as coreGetFullYear } from "./_core/getFullYear.js";

/**
 * The {@link isSameMonth} function options.
 */

/**
 * @name isSameMonth
 * @category Month Helpers
 * @summary Are the given dates in the same month (and year)?
 *
 * @description
 * Are the given dates in the same month (and year)?
 *
 * @param laterDate - The first date to check
 * @param earlierDate - The second date to check
 * @param options - An object with options
 *
 * @returns The dates are in the same month (and year)
 *
 * @example
 * // Are 2 September 2014 and 25 September 2014 in the same month?
 * const result = isSameMonth(new Date(2014, 8, 2), new Date(2014, 8, 25))
 * //=> true
 *
 * @example
 * // Are 2 September 2014 and 25 September 2015 in the same month?
 * const result = isSameMonth(new Date(2014, 8, 2), new Date(2015, 8, 25))
 * //=> false
 */
export function isSameMonth(laterDate, earlierDate, options) {
  const [laterDate_, earlierDate_] = normalizeDates(
    options?.in,
    laterDate,
    earlierDate,
  );
  return (
    coreGetFullYear(laterDate_) === coreGetFullYear(earlierDate_) &&
    coreGetMonth(laterDate_) === coreGetMonth(earlierDate_)
  );
}

// Fallback for modularized imports:
export default isSameMonth;
