import type React from "react"
import { Brain, Sparkles, Bot, Target, TrendingUp, Zap, Code } from "lucide-react"

interface Expertise {
  name: string
  icon: React.ComponentType<{ className?: string }>
}

interface Stat {
  value: string
  label: string
}

interface Approach {
  title: string
  description: string
  icon: React.ComponentType<{ className?: string }>
}

export default function About() {
  const expertise: Expertise[] = [
    { name: "Custom AI Model Development", icon: Brain },
    { name: "Business Process Automation", icon: Sparkles },
    { name: "Machine Learning Algorithms", icon: TrendingUp },
    { name: "Natural Language Processing", icon: Bot },
    { name: "Computer Vision Solutions", icon: Target },
    { name: "AI Chatbots & Virtual Assistants", icon: Bot },
    { name: "Predictive Analytics", icon: Zap },
    { name: "AI System Integration", icon: Code },
  ]

  const stats: Stat[] = [
    { value: "250+", label: "AI Solutions Delivered" },
    { value: "500+", label: "Processes Automated" },
    { value: "99%", label: "Client Satisfaction" },
    { value: "25+", label: "Industries Served" },
  ]

  const approaches: Approach[] = [
    {
      title: "AI-First Approach",
      description:
        "We leverage cutting-edge AI technologies including deep learning, NLP, and computer vision to solve complex business problems.",
      icon: Brain,
    },
    {
      title: "Automation Excellence",
      description:
        "Our expertise in business process automation helps companies eliminate manual work and achieve operational efficiency.",
      icon: Sparkles,
    },
    {
      title: "Measurable Results",
      description:
        "Every AI solution we build is designed to deliver quantifiable business impact and ROI within weeks of deployment.",
      icon: TrendingUp,
    },
  ]

  return (
    <section id="about" className="relative py-20 bg-gradient-to-b from-black to-gray-950">
      <div className="max-w-7xl mx-auto px-6">
        {/* Main about section */}
        <div className="text-center mb-16">
          <h2 className="text-4xl md:text-5xl font-bold mb-6">
            <span className="text-white">About </span>
            <span className="text-transparent bg-clip-text bg-gradient-to-r from-orange-400 via-pink-500 to-purple-600">
              Ainoxa
            </span>
          </h2>
          <p className="text-gray-400 text-lg max-w-4xl mx-auto leading-relaxed mb-4">
            We are Ainoxa - a specialized AI automation agency with a team of machine learning engineers, AI
            researchers, and automation experts dedicated to transforming businesses through intelligent automation.
          </p>
          <p className="text-gray-400 text-lg max-w-4xl mx-auto leading-relaxed">
            Our mission is to make AI automation accessible and practical for businesses worldwide. We've successfully
            automated hundreds of business processes, deployed intelligent chatbots, and built custom AI models that
            solve real-world challenges across manufacturing, healthcare, finance, and e-commerce sectors.
          </p>
        </div>

        {/* Expertise grid */}
        <div className="mb-16">
          <h3 className="text-2xl font-bold text-white text-center mb-8">Our AI Expertise</h3>
          <div className="grid grid-cols-2 md:grid-cols-4 gap-4">
            {expertise.map((item, index) => {
              const Icon = item.icon
              return (
                <div
                  key={index}
                  className="flex items-center gap-3 bg-gray-900/50 border border-orange-500/20 rounded-xl p-4 hover:border-orange-500/50 transition-all cursor-pointer group"
                >
                  <Icon className="w-5 h-5 text-orange-400 group-hover:scale-110 transition-transform" />
                  <span className="text-gray-300 text-sm">{item.name}</span>
                </div>
              )
            })}
          </div>
          <div className="flex justify-center mt-8">
            <button className="border border-orange-500 text-orange-400 px-8 py-3 rounded-lg hover:bg-gradient-to-r hover:from-orange-500/10 hover:to-pink-500/10 transition-all">
              Learn More About Us
            </button>
          </div>
        </div>

        {/* Stats */}
        <div className="grid grid-cols-2 md:grid-cols-4 gap-6 mb-16">
          {stats.map((stat, index) => (
            <div key={index} className="text-center">
              <div className="text-5xl font-bold text-transparent bg-clip-text bg-gradient-to-r from-orange-400 via-pink-500 to-purple-600 mb-2">
                {stat.value}
              </div>
              <div className="text-gray-400 text-sm">{stat.label}</div>
            </div>
          ))}
        </div>

        {/* Our Approach */}
        <div className="mb-16">
          <h3 className="text-2xl font-bold text-white text-center mb-8">Our AI Approach</h3>
          <div className="grid grid-cols-1 md:grid-cols-3 gap-6">
            {approaches.map((approach, index) => {
              const Icon = approach.icon
              const gradients = [
                "from-orange-500 to-pink-600",
                "from-pink-500 to-purple-600",
                "from-purple-500 to-pink-600",
              ]
              return (
                <div
                  key={index}
                  className="bg-gradient-to-br from-gray-900/90 to-gray-900/50 border border-orange-500/20 rounded-2xl p-6 hover:border-orange-500/50 transition-all"
                >
                  <div
                    className={`w-12 h-12 bg-gradient-to-br ${gradients[index]} rounded-xl flex items-center justify-center mb-4 shadow-lg`}
                  >
                    <Icon className="w-6 h-6 text-white" />
                  </div>
                  <h4 className="text-xl font-bold text-white mb-3">{approach.title}</h4>
                  <p className="text-gray-400 text-sm leading-relaxed">{approach.description}</p>
                </div>
              )
            })}
          </div>
        </div>

        {/* Mission */}
        <div className="bg-gradient-to-br from-orange-600/20 via-pink-600/20 to-purple-600/20 border border-orange-500/30 rounded-3xl p-12 text-center">
          <div className="inline-flex items-center gap-2 px-4 py-2 rounded-full bg-orange-500/20 border border-orange-500/30 text-orange-400 text-sm mb-6">
            Our Mission
          </div>
          <h3 className="text-3xl font-bold text-white mb-4">Empowering Businesses Through AI</h3>
          <p className="text-gray-300 max-w-3xl mx-auto leading-relaxed">
            To democratize AI automation for businesses worldwide, helping them transform their operations through
            intelligent systems that reduce costs, eliminate manual work, and drive sustainable growth.
          </p>
        </div>
      </div>
    </section>
  )
}
