import { ArrowRight } from "lucide-react"

interface Result {
  label: string
  value: string
}

interface CaseStudy {
  category: string
  company: string
  challenge: string
  solution: string
  results: Result[]
  color: string
}

export default function CaseStudies() {
  const caseStudies: CaseStudy[] = [
    {
      category: "Manufacturing Automation",
      company: "Gujarat Manufacturing Co.",
      challenge:
        "Manual production monitoring and quality control was consuming 8+ hours daily, causing bottlenecks and quality inconsistencies.",
      solution:
        "Deployed custom AI vision system with real-time defect detection and automated production line optimization.",
      results: [
        { label: "Reduction in manual inspection time", value: "80%" },
        { label: "Defect detection accuracy", value: "95%" },
        { label: "Increase in production efficiency", value: "60%" },
      ],
      color: "from-blue-500 to-cyan-500",
    },
    {
      category: "Financial Services",
      company: "Ahmedabad FinTech Solutions",
      challenge:
        "Processing loan applications and document verification was taking 3-5 days, impacting customer satisfaction.",
      solution:
        "Built intelligent document processing system with NLP-powered risk assessment and automated approval workflows.",
      results: [
        { label: "Faster loan processing", value: "90%" },
        { label: "Reduction in manual work", value: "70%" },
        { label: "Document processing accuracy", value: "99%" },
      ],
      color: "from-purple-500 to-pink-500",
    },
    {
      category: "Healthcare Technology",
      company: "Rajkot Healthcare Network",
      challenge:
        "Patient data management and appointment scheduling was inefficient, leading to long wait times and administrative burden.",
      solution:
        "Implemented AI-powered patient management system with intelligent scheduling and automated follow-up communications.",
      results: [
        { label: "Reduction in wait times", value: "75%" },
        { label: "Improvement in patient satisfaction", value: "85%" },
        { label: "Decrease in administrative workload", value: "50%" },
      ],
      color: "from-green-500 to-emerald-500",
    },
  ]

  return (
    <section id="case-studies" className="relative py-20 bg-black">
      <div className="max-w-7xl mx-auto px-6">
        {/* Section badge */}
        <div className="flex justify-center mb-6">
          <div className="inline-flex items-center gap-2 px-4 py-2 rounded-full bg-green-500/10 border border-green-500/30 text-green-400 text-sm">
            Real Results, Real Impact
          </div>
        </div>

        {/* Section heading */}
        <h2 className="text-4xl md:text-5xl font-bold text-center mb-4">
          <span className="text-white">AI Automation </span>
          <span className="text-transparent bg-clip-text bg-gradient-to-r from-blue-400 to-purple-500">
            Success Stories
          </span>
        </h2>

        <p className="text-gray-400 text-center max-w-3xl mx-auto mb-16 text-lg">
          See how our custom AI automation solutions have transformed businesses across Gujarat and India, delivering
          measurable improvements in efficiency, accuracy, and cost reduction.
        </p>

        {/* Case studies */}
        <div className="grid grid-cols-1 lg:grid-cols-3 gap-6">
          {caseStudies.map((study, index) => (
            <div key={index} className="group relative">
              <div
                className={`absolute inset-0 bg-gradient-to-r ${study.color} rounded-2xl opacity-0 group-hover:opacity-20 blur-xl transition-opacity`}
              ></div>
              <div className="relative bg-gradient-to-br from-gray-900/90 to-gray-900/50 border border-gray-800 rounded-2xl p-6 hover:border-gray-700 transition-all h-full flex flex-col">
                {/* Category badge */}
                <div className="text-blue-400 text-sm font-semibold mb-3">{study.category}</div>

                {/* Company */}
                <h3 className="text-2xl font-bold text-white mb-4">{study.company}</h3>

                {/* Challenge */}
                <div className="mb-4">
                  <h4 className="text-sm font-semibold text-gray-400 mb-2">Challenge</h4>
                  <p className="text-gray-300 text-sm leading-relaxed">{study.challenge}</p>
                </div>

                {/* Solution */}
                <div className="mb-6">
                  <h4 className="text-sm font-semibold text-gray-400 mb-2">Our Solution</h4>
                  <p className="text-gray-300 text-sm leading-relaxed">{study.solution}</p>
                </div>

                {/* Results */}
                <div className="mb-6">
                  <h4 className="text-sm font-semibold text-gray-400 mb-3">Results</h4>
                  <div className="space-y-3">
                    {study.results.map((result, rIndex) => (
                      <div key={rIndex} className="flex items-center justify-between">
                        <span className="text-gray-400 text-xs">{result.label}</span>
                        <span
                          className={`text-2xl font-bold bg-gradient-to-r ${study.color} bg-clip-text text-transparent`}
                        >
                          {result.value}
                        </span>
                      </div>
                    ))}
                  </div>
                </div>

                {/* CTA buttons */}
                <div className="mt-auto space-y-2">
                  <button className="w-full flex items-center justify-center gap-2 bg-gray-800/50 hover:bg-gray-800 border border-gray-700 text-white px-4 py-3 rounded-lg transition-all">
                    Read Full Case Study <ArrowRight className="w-4 h-4" />
                  </button>
                  <button className="w-full flex items-center justify-center gap-2 text-gray-400 hover:text-white px-4 py-2 rounded-lg transition-all text-sm">
                    Read More
                  </button>
                </div>
              </div>
            </div>
          ))}
        </div>

        {/* Stats */}
        <div className="grid grid-cols-2 md:grid-cols-4 gap-6 mt-16">
          <div className="text-center">
            <div className="text-5xl font-bold text-transparent bg-clip-text bg-gradient-to-r from-blue-400 to-purple-500 mb-2">
              0+
            </div>
            <div className="text-gray-400 text-sm">Projects Completed</div>
          </div>
          <div className="text-center">
            <div className="text-5xl font-bold text-transparent bg-clip-text bg-gradient-to-r from-blue-400 to-purple-500 mb-2">
              0%
            </div>
            <div className="text-gray-400 text-sm">Client Satisfaction</div>
          </div>
          <div className="text-center">
            <div className="text-5xl font-bold text-transparent bg-clip-text bg-gradient-to-r from-blue-400 to-purple-500 mb-2">
              40-60%
            </div>
            <div className="text-gray-400 text-sm">Average Cost Reduction</div>
          </div>
          <div className="text-center">
            <div className="text-5xl font-bold text-transparent bg-clip-text bg-gradient-to-r from-blue-400 to-purple-500 mb-2">
              0+
            </div>
            <div className="text-gray-400 text-sm">Cities in India</div>
          </div>
        </div>

        {/* CTA */}
        <div className="mt-16 text-center">
          <h3 className="text-3xl font-bold text-white mb-4">Ready to Join Our Success Stories?</h3>
          <p className="text-gray-400 mb-8">
            Let's discuss how we can transform your business operations and help you achieve similar results with our AI
            automation solutions.
          </p>
          <div className="flex flex-wrap items-center justify-center gap-4">
            <button className="bg-white text-black px-8 py-4 rounded-lg font-semibold hover:bg-gray-200 transition-all hover:scale-105">
              Start Your Project
            </button>
            <button className="border border-gray-600 text-white px-8 py-4 rounded-lg font-semibold hover:border-blue-500 hover:bg-blue-500/10 transition-all">
              Schedule Demo
            </button>
          </div>
        </div>
      </div>
    </section>
  )
}
