import { MessageCircle } from "lucide-react"

export default function ChatWidget() {
  return (
    <button className="fixed bottom-6 right-6 z-50 w-14 h-14 bg-gradient-to-br from-orange-500 via-pink-500 to-purple-600 hover:shadow-2xl hover:shadow-orange-500/50 rounded-full flex items-center justify-center transition-all hover:scale-110 group">
      <MessageCircle className="w-7 h-7 text-white" />
      <span className="absolute right-full mr-3 bg-gray-900 border border-orange-500/30 text-white px-4 py-2 rounded-lg text-sm whitespace-nowrap opacity-0 group-hover:opacity-100 transition-opacity pointer-events-none">
        Chat with us
      </span>
    </button>
  )
}
