"use client"

import type React from "react"

import { useState } from "react"
import { Mail, Phone, MapPin, Clock, Send, MessageCircle } from "lucide-react"

interface FormData {
  firstName: string
  lastName: string
  email: string
  phone: string
  company: string
  service: string
  projectDetails: string
}

export default function Contact() {
  const [formData, setFormData] = useState<FormData>({
    firstName: "",
    lastName: "",
    email: "",
    phone: "",
    company: "",
    service: "",
    projectDetails: "",
  })

  const handleSubmit = (e: React.FormEvent) => {
    e.preventDefault()
    console.log("Form submitted:", formData)
    alert("Thank you! We will get back to you within 24 hours.")
    setFormData({
      firstName: "",
      lastName: "",
      email: "",
      phone: "",
      company: "",
      service: "",
      projectDetails: "",
    })
  }

  const handleChange = (e: React.ChangeEvent<HTMLInputElement | HTMLSelectElement | HTMLTextAreaElement>) => {
    setFormData({
      ...formData,
      [e.target.name]: e.target.value,
    })
  }

  return (
    <section id="contact" className="relative py-20 bg-gradient-to-b from-[#0a0a0f] to-black">
      <div className="max-w-7xl mx-auto px-6">
        {/* Section heading */}
        <div className="text-center mb-16">
          <h2 className="text-4xl md:text-5xl font-bold mb-4">
            <span className="text-white">Let's Build Something Amazing Together</span>
          </h2>
          <h3 className="text-3xl font-bold mb-4">
            <span className="text-white">Ready to Transform </span>
            <span className="text-transparent bg-clip-text bg-gradient-to-r from-blue-400 to-purple-500">
              Your Business?
            </span>
          </h3>
          <p className="text-gray-400 max-w-3xl mx-auto">
            Join hundreds of forward-thinking companies who've revolutionized their operations with our AI-powered
            automation solutions. Let's discuss how we can accelerate your digital transformation.
          </p>

          <div className="flex flex-wrap justify-center gap-4 mt-8">
            <div className="px-6 py-2 bg-green-500/20 border border-green-500/30 rounded-lg text-green-400 text-sm">
              24/7 Support
            </div>
            <div className="px-6 py-2 bg-blue-500/20 border border-blue-500/30 rounded-lg text-blue-400 text-sm">
              Free Consultation
            </div>
            <div className="px-6 py-2 bg-purple-500/20 border border-purple-500/30 rounded-lg text-purple-400 text-sm">
              Custom Solutions
            </div>
          </div>
        </div>

        <div className="grid grid-cols-1 lg:grid-cols-2 gap-12">
          {/* Contact form */}
          <div>
            <div className="bg-gradient-to-br from-gray-900/90 to-gray-900/50 border border-gray-800 rounded-2xl p-8">
              <h3 className="text-2xl font-bold text-white mb-6">Let's Start Your AI Transformation</h3>
              <p className="text-gray-400 mb-6">
                Fill out the form below and our AI experts will get back to you within 24 hours
              </p>

              <form onSubmit={handleSubmit} className="space-y-6">
                <div className="grid grid-cols-2 gap-4">
                  <div>
                    <label className="block text-gray-400 text-sm mb-2">First Name *</label>
                    <input
                      type="text"
                      name="firstName"
                      value={formData.firstName}
                      onChange={handleChange}
                      required
                      className="w-full bg-gray-800/50 border border-gray-700 rounded-lg px-4 py-3 text-white focus:border-blue-500 focus:outline-none transition-colors"
                      placeholder="John"
                    />
                  </div>
                  <div>
                    <label className="block text-gray-400 text-sm mb-2">Last Name *</label>
                    <input
                      type="text"
                      name="lastName"
                      value={formData.lastName}
                      onChange={handleChange}
                      required
                      className="w-full bg-gray-800/50 border border-gray-700 rounded-lg px-4 py-3 text-white focus:border-blue-500 focus:outline-none transition-colors"
                      placeholder="Doe"
                    />
                  </div>
                </div>

                <div>
                  <label className="block text-gray-400 text-sm mb-2">Email *</label>
                  <input
                    type="email"
                    name="email"
                    value={formData.email}
                    onChange={handleChange}
                    required
                    className="w-full bg-gray-800/50 border border-gray-700 rounded-lg px-4 py-3 text-white focus:border-blue-500 focus:outline-none transition-colors"
                    placeholder="john@company.com"
                  />
                </div>

                <div>
                  <label className="block text-gray-400 text-sm mb-2">Phone *</label>
                  <input
                    type="tel"
                    name="phone"
                    value={formData.phone}
                    onChange={handleChange}
                    required
                    className="w-full bg-gray-800/50 border border-gray-700 rounded-lg px-4 py-3 text-white focus:border-blue-500 focus:outline-none transition-colors"
                    placeholder="+91 98765 43210"
                  />
                </div>

                <div>
                  <label className="block text-gray-400 text-sm mb-2">Company *</label>
                  <input
                    type="text"
                    name="company"
                    value={formData.company}
                    onChange={handleChange}
                    required
                    className="w-full bg-gray-800/50 border border-gray-700 rounded-lg px-4 py-3 text-white focus:border-blue-500 focus:outline-none transition-colors"
                    placeholder="Your Company Name"
                  />
                </div>

                <div>
                  <label className="block text-gray-400 text-sm mb-2">Service Interest</label>
                  <select
                    name="service"
                    value={formData.service}
                    onChange={handleChange}
                    className="w-full bg-gray-800/50 border border-gray-700 rounded-lg px-4 py-3 text-white focus:border-blue-500 focus:outline-none transition-colors"
                  >
                    <option value="">Select a service</option>
                    <option value="custom-ai">Custom AI Development</option>
                    <option value="automation">Business Process Automation</option>
                    <option value="chatbot">AI Chatbot Solutions</option>
                    <option value="ml">Machine Learning Models</option>
                    <option value="vision">Computer Vision Systems</option>
                    <option value="consulting">AI Strategy Consulting</option>
                  </select>
                </div>

                <div>
                  <label className="block text-gray-400 text-sm mb-2">Project Details *</label>
                  <textarea
                    name="projectDetails"
                    value={formData.projectDetails}
                    onChange={handleChange}
                    required
                    rows={4}
                    className="w-full bg-gray-800/50 border border-gray-700 rounded-lg px-4 py-3 text-white focus:border-blue-500 focus:outline-none transition-colors resize-none"
                    placeholder="Tell us about your project requirements..."
                  />
                </div>

                <button
                  type="submit"
                  className="w-full flex items-center justify-center gap-2 bg-white text-black px-8 py-4 rounded-lg font-semibold hover:bg-gray-200 transition-all hover:scale-105"
                >
                  <Send className="w-5 h-5" /> Send Message & Start Your AI Journey
                </button>

                <p className="text-gray-400 text-sm text-center">
                  We'll respond within 24 hours with a personalized AI strategy
                </p>
              </form>
            </div>
          </div>

          {/* Contact info */}
          <div className="space-y-6">
            {/* Contact details */}
            <div className="bg-gradient-to-br from-gray-900/90 to-gray-900/50 border border-gray-800 rounded-2xl p-8">
              <h3 className="text-2xl font-bold text-white mb-6">Contact Us</h3>
              <p className="text-gray-400 mb-6">
                Get in touch with us through email or phone for AI automation consultation and project discussions
              </p>

              <div className="space-y-4">
                <div className="flex items-start gap-4">
                  <div className="w-12 h-12 bg-blue-600/20 rounded-xl flex items-center justify-center flex-shrink-0">
                    <Mail className="w-6 h-6 text-blue-500" />
                  </div>
                  <div>
                    <div className="text-sm text-gray-400 mb-1">Sales & Business</div>
                    <a
                      href="mailto:sales@nenotechnology.com"
                      className="text-white hover:text-blue-400 transition-colors"
                    >
                      sales@nenotechnology.com
                    </a>
                    <div className="text-xs text-gray-500 mt-1">Email</div>
                  </div>
                </div>

                <div className="flex items-start gap-4">
                  <div className="w-12 h-12 bg-green-600/20 rounded-xl flex items-center justify-center flex-shrink-0">
                    <Phone className="w-6 h-6 text-green-500" />
                  </div>
                  <div>
                    <div className="text-sm text-gray-400 mb-1">Phone Support</div>
                    <a href="tel:+919106915561" className="text-white hover:text-green-400 transition-colors">
                      +91 9106915561
                    </a>
                    <div className="text-xs text-gray-500 mt-1">Call</div>
                  </div>
                </div>
              </div>
            </div>

            {/* Location */}
            <div className="bg-gradient-to-br from-gray-900/90 to-gray-900/50 border border-gray-800 rounded-2xl p-8">
              <h3 className="text-2xl font-bold text-white mb-6">Visit Us</h3>
              <p className="text-gray-400 mb-6">Visit our AI development center for in-person meetings</p>

              <div className="flex items-start gap-4 mb-6">
                <div className="w-12 h-12 bg-purple-600/20 rounded-xl flex items-center justify-center flex-shrink-0">
                  <MapPin className="w-6 h-6 text-purple-500" />
                </div>
                <div>
                  <div className="text-white font-semibold mb-1">Ihub Gujarat, Prajna Puram</div>
                  <div className="text-gray-400 text-sm">
                    KCG Campus, opp. PRL, Navrangpura
                    <br />
                    Ahmedabad, Gujarat 380015
                  </div>
                </div>
              </div>

              <button className="w-full border border-gray-700 text-white px-4 py-3 rounded-lg hover:border-blue-500 hover:bg-blue-500/10 transition-all">
                Get Directions
              </button>
            </div>

            {/* Business hours */}
            <div className="bg-gradient-to-br from-gray-900/90 to-gray-900/50 border border-gray-800 rounded-2xl p-8">
              <h3 className="text-2xl font-bold text-white mb-6">Business Hours</h3>
              <p className="text-gray-400 mb-6">We're here when you need us - online support available anytime</p>

              <div className="space-y-3">
                <div className="flex items-center gap-3">
                  <Clock className="w-5 h-5 text-blue-500" />
                  <div>
                    <span className="text-white font-medium">Mon-Fri:</span>
                    <span className="text-gray-400 ml-2">9AM-6PM IST</span>
                  </div>
                </div>
                <div className="flex items-center gap-3">
                  <Clock className="w-5 h-5 text-green-500" />
                  <div>
                    <span className="text-white font-medium">Sat:</span>
                    <span className="text-gray-400 ml-2">10AM-4PM IST</span>
                  </div>
                </div>
                <div className="flex items-center gap-3">
                  <MessageCircle className="w-5 h-5 text-purple-500" />
                  <div>
                    <span className="text-white font-medium">24/7 Online Support</span>
                  </div>
                </div>
              </div>
            </div>

            {/* Get started options */}
            {/* <div className="bg-gradient-to-br from-blue-600/20 to-purple-600/20 border border-blue-500/30 rounded-2xl p-8">
              <h3 className="text-xl font-bold text-white mb-4">Get Started Today</h3>
              <p className="text-gray-300 text-sm mb-6">Choose your preferred way to connect with our AI experts</p>

              <div className="grid grid-cols-2 gap-3">
                <button className="bg-white text-black px-4 py-3 rounded-lg font-medium hover:bg-gray-200 transition-all text-sm">
                  Email
                </button>
                <button className="bg-gray-800 text-white px-4 py-3 rounded-lg font-medium hover:bg-gray-700 transition-all text-sm">
                  Call
                </button>
                <button className="bg-green-600 text-white px-4 py-3 rounded-lg font-medium hover:bg-green-700 transition-all text-sm">
                  WhatsApp
                </button>
                <button className="bg-blue-600 text-white px-4 py-3 rounded-lg font-medium hover:bg-blue-700 transition-all text-sm">
                  Demo
                </button>
              </div>

              <div className="mt-6 text-center">
                <div className="text-sm text-gray-300 mb-2">24/7 Support • Free Consultation</div>
              </div>
            </div> */}
          </div>
        </div>

        {/* Map section */}
        <div className="mt-16">
          <div className="bg-gradient-to-br from-gray-900/90 to-gray-900/50 border border-gray-800 rounded-2xl p-8">
            <h3 className="text-2xl font-bold text-white mb-6">Visit Our Innovation Hub</h3>
            <p className="text-gray-400 mb-6">
              Located in the heart of Ahmedabad's tech district, our state-of-the-art facility is where AI innovation
              meets business transformation.
            </p>

            <div className="grid grid-cols-1 md:grid-cols-2 gap-6">
              <div>
                <h4 className="text-lg font-semibold text-white mb-4">Find Our Location</h4>
                <div className="space-y-3">
                  <div className="flex justify-between py-2 border-b border-gray-800">
                    <span className="text-gray-400">City</span>
                    <span className="text-white">Ahmedabad</span>
                  </div>
                  <div className="flex justify-between py-2 border-b border-gray-800">
                    <span className="text-gray-400">State</span>
                    <span className="text-white">Gujarat</span>
                  </div>
                  <div className="flex justify-between py-2 border-b border-gray-800">
                    <span className="text-gray-400">Country</span>
                    <span className="text-white">India</span>
                  </div>
                  <div className="flex justify-between py-2 border-b border-gray-800">
                    <span className="text-gray-400">PIN Code</span>
                    <span className="text-white">380015</span>
                  </div>
                </div>
                <button className="mt-6 w-full bg-blue-600 text-white px-6 py-3 rounded-lg font-semibold hover:bg-blue-700 transition-all">
                  View on Map
                </button>
              </div>

              <div>
                <h4 className="text-lg font-semibold text-white mb-4">Nenotechnology HQ</h4>
                <div className="space-y-3">
                  <div className="flex justify-between py-2 border-b border-gray-800">
                    <span className="text-gray-400">Distance from Airport</span>
                    <span className="text-white">15 km</span>
                  </div>
                  <div className="flex justify-between py-2 border-b border-gray-800">
                    <span className="text-gray-400">Nearest Metro</span>
                    <span className="text-white">2 km</span>
                  </div>
                  <div className="flex justify-between py-2 border-b border-gray-800">
                    <span className="text-gray-400">Business Hours</span>
                    <span className="text-white">9AM-6PM</span>
                  </div>
                  <div className="flex justify-between py-2 border-b border-gray-800">
                    <span className="text-gray-400">Parking</span>
                    <span className="text-white">Available</span>
                  </div>
                </div>
                <div className="mt-6 text-gray-400 text-sm">
                  <p>📍 Ihub Gujarat, Prajna Puram, KCG Campus, opp. PRL, Navrangpura, Ahmedabad, Gujarat 380015</p>
                </div>
              </div>
            </div>
          </div>
        </div>

        {/* Final stats */}
        <div className="grid grid-cols-2 md:grid-cols-4 gap-6 mt-16">
          <div className="text-center">
            <div className="text-5xl font-bold text-transparent bg-clip-text bg-gradient-to-r from-blue-400 to-purple-500 mb-2">
              100+
            </div>
            <div className="text-gray-400 text-sm">Projects Completed</div>
          </div>
          <div className="text-center">
            <div className="text-5xl font-bold text-transparent bg-clip-text bg-gradient-to-r from-blue-400 to-purple-500 mb-2">
              98%
            </div>
            <div className="text-gray-400 text-sm">Client Satisfaction</div>
          </div>
          <div className="text-center">
            <div className="text-5xl font-bold text-transparent bg-clip-text bg-gradient-to-r from-blue-400 to-purple-500 mb-2">
              24/7
            </div>
            <div className="text-gray-400 text-sm">Support Available</div>
          </div>
          <div className="text-center">
            <div className="text-5xl font-bold text-transparent bg-clip-text bg-gradient-to-r from-blue-400 to-purple-500 mb-2">
              2+
            </div>
            <div className="text-gray-400 text-sm">Years Experience</div>
          </div>
        </div>
      </div>
    </section>
  )
}
