import { Sparkles, Play, Cpu, Zap, Bot, Brain } from "lucide-react"

export default function Hero() {
  return (
    <section className="relative min-h-screen bg-[#0A0A0A] pt-20 sm:pt-24 pb-12 sm:pb-20 overflow-hidden">
      {/* Animated background elements */}
      <div className="absolute inset-0 overflow-hidden">
        <div className="absolute top-20 left-10 w-64 h-64 bg-[#00AEEF]/10 rounded-full blur-3xl animate-pulse"></div>
        <div
          className="absolute top-40 right-10 w-80 h-80 bg-[#8A2BE2]/10 rounded-full blur-3xl animate-pulse"
          style={{ animationDelay: "1s" }}
        ></div>
        <div
          className="absolute bottom-40 left-1/4 w-48 h-48 bg-[#00AEEF]/10 rounded-full blur-3xl animate-pulse"
          style={{ animationDelay: "2s" }}
        ></div>
        <div
          className="absolute bottom-20 right-1/4 w-56 h-56 bg-[#8A2BE2]/10 rounded-full blur-3xl animate-pulse"
          style={{ animationDelay: "1.5s" }}
        ></div>
        {/* Grid pattern */}
        <div
          className="absolute inset-0"
          style={{
            backgroundImage:
              "linear-gradient(#00AEEF 1px, transparent 1px), linear-gradient(90deg, #00AEEF 1px, transparent 1px)",
            backgroundSize: "50px 50px",
            opacity: "0.05",
          }}
        ></div>
      </div>

      <div className="relative max-w-7xl mx-auto px-4 sm:px-6 text-center">
        {/* Badge */}
        <div
          className="inline-flex items-center gap-2 px-3 sm:px-4 py-2 rounded-full bg-[#00AEEF]/10 border border-[#00AEEF]/30 text-[#00AEEF] text-xs sm:text-sm mb-6 sm:mb-8 flex-wrap justify-center"
          style={{ boxShadow: "0 0 20px rgba(0,174,239,0.3)" }}
        >
          <div
            className="w-2 h-2 bg-[#00AEEF] rounded-full animate-pulse"
            style={{ boxShadow: "0 0 10px rgba(0,174,239,0.8)" }}
          ></div>
          <span>AI-Powered Innovation & Automation Platform</span>
          <div
            className="w-2 h-2 bg-[#8A2BE2] rounded-full animate-pulse"
            style={{ boxShadow: "0 0 10px rgba(138,43,226,0.8)" }}
          ></div>
        </div>

        {/* Main heading */}
        <h1 className="text-3xl sm:text-4xl md:text-5xl lg:text-6xl xl:text-7xl font-bold text-white mb-4 sm:mb-6 leading-tight">
          Transform Your Business with
          <br />
          <span
            className="text-transparent bg-clip-text bg-gradient-to-r from-[#00AEEF] via-[#8A2BE2] to-[#00AEEF]"
            style={{ textShadow: "0 0 40px rgba(0,174,239,0.5)" }}
          >
            AI Automation
          </span>
        </h1>

        {/* Description */}
        <p className="text-[#A3A3A3] text-sm sm:text-base md:text-lg lg:text-xl max-w-4xl mx-auto mb-8 sm:mb-10 leading-relaxed px-2">
          We're Ainoxa - an innovative AI agency that builds custom automation solutions for modern businesses. From
          intelligent chatbots to automated workflows, we create AI systems that solve your specific challenges and
          drive unprecedented growth.
        </p>

        {/* CTA Buttons */}
        <div className="flex flex-col sm:flex-row items-center justify-center gap-3 sm:gap-4 mb-12 sm:mb-16 px-2">
          <button
            className="w-full sm:w-auto flex items-center justify-center gap-2 bg-gradient-to-r from-[#00AEEF] to-[#8A2BE2] text-white px-6 sm:px-8 py-3 sm:py-4 rounded-lg font-semibold transition-all hover:scale-105 text-sm sm:text-base"
            style={{ boxShadow: "0 0 30px rgba(0,174,239,0.6)" }}
          >
            <Sparkles className="w-4 h-4 sm:w-5 sm:h-5" /> Get AI Consultation
          </button>
          <button
            className="w-full sm:w-auto flex items-center justify-center gap-2 border border-[#8A2BE2] text-[#8A2BE2] px-6 sm:px-8 py-3 sm:py-4 rounded-lg font-semibold hover:bg-[#8A2BE2]/10 transition-all text-sm sm:text-base"
            style={{ boxShadow: "0 0 20px rgba(138,43,226,0.3)" }}
          >
            <Play className="w-4 h-4 sm:w-5 sm:h-5" /> View AI Solutions
          </button>
        </div>

        {/* Service badges */}
        <div className="flex flex-col sm:flex-row flex-wrap items-center justify-center gap-3 sm:gap-4 px-2">
          <div
            className="w-full sm:w-auto flex items-center gap-2 sm:gap-3 px-4 sm:px-6 py-2 sm:py-3 rounded-full bg-[#00AEEF]/10 border border-[#00AEEF]/30 hover:bg-[#00AEEF]/20 transition-all cursor-pointer group text-sm sm:text-base"
            style={{ boxShadow: "0 0 20px rgba(0,174,239,0.2)" }}
          >
            <div
              className="w-8 h-8 sm:w-10 sm:h-10 bg-gradient-to-br from-[#00AEEF] to-[#8A2BE2] rounded-full flex items-center justify-center group-hover:scale-110 transition-transform flex-shrink-0"
              style={{ boxShadow: "0 0 20px rgba(0,174,239,0.5)" }}
            >
              <Cpu className="w-4 h-4 sm:w-5 sm:h-5 text-white" />
            </div>
            <span className="text-white font-medium">Custom AI Development</span>
          </div>

          <div
            className="w-full sm:w-auto flex items-center gap-2 sm:gap-3 px-4 sm:px-6 py-2 sm:py-3 rounded-full bg-[#8A2BE2]/10 border border-[#8A2BE2]/30 hover:bg-[#8A2BE2]/20 transition-all cursor-pointer group text-sm sm:text-base"
            style={{ boxShadow: "0 0 20px rgba(138,43,226,0.2)" }}
          >
            <div
              className="w-8 h-8 sm:w-10 sm:h-10 bg-gradient-to-br from-[#8A2BE2] to-[#00AEEF] rounded-full flex items-center justify-center group-hover:scale-110 transition-transform flex-shrink-0"
              style={{ boxShadow: "0 0 20px rgba(138,43,226,0.5)" }}
            >
              <Zap className="w-4 h-4 sm:w-5 sm:h-5 text-white" />
            </div>
            <span className="text-white font-medium">Business Process Automation</span>
          </div>

          <div
            className="w-full sm:w-auto flex items-center gap-2 sm:gap-3 px-4 sm:px-6 py-2 sm:py-3 rounded-full bg-[#00AEEF]/10 border border-[#00AEEF]/30 hover:bg-[#00AEEF]/20 transition-all cursor-pointer group text-sm sm:text-base"
            style={{ boxShadow: "0 0 20px rgba(0,174,239,0.2)" }}
          >
            <div
              className="w-8 h-8 sm:w-10 sm:h-10 bg-gradient-to-br from-[#00AEEF] to-[#8A2BE2] rounded-full flex items-center justify-center group-hover:scale-110 transition-transform flex-shrink-0"
              style={{ boxShadow: "0 0 20px rgba(0,174,239,0.5)" }}
            >
              <Bot className="w-4 h-4 sm:w-5 sm:h-5 text-white" />
            </div>
            <span className="text-white font-medium">AI-Powered Chatbots</span>
          </div>

          <div
            className="w-full sm:w-auto flex items-center gap-2 sm:gap-3 px-4 sm:px-6 py-2 sm:py-3 rounded-full bg-[#8A2BE2]/10 border border-[#8A2BE2]/30 hover:bg-[#8A2BE2]/20 transition-all cursor-pointer group text-sm sm:text-base"
            style={{ boxShadow: "0 0 20px rgba(138,43,226,0.2)" }}
          >
            <div
              className="w-8 h-8 sm:w-10 sm:h-10 bg-gradient-to-br from-[#8A2BE2] to-[#00AEEF] rounded-full flex items-center justify-center group-hover:scale-110 transition-transform flex-shrink-0"
              style={{ boxShadow: "0 0 20px rgba(138,43,226,0.5)" }}
            >
              <Brain className="w-4 h-4 sm:w-5 sm:h-5 text-white" />
            </div>
            <span className="text-white font-medium">Machine Learning Models</span>
          </div>
        </div>
      </div>
    </section>
  )
}
