"use client"

import { useState } from "react"
import { Sparkles, ChevronDown, Menu, X } from "lucide-react"

export default function Navbar() {
  const [solutionsOpen, setSolutionsOpen] = useState(false)
  const [mobileMenuOpen, setMobileMenuOpen] = useState(false)

  return (
    <nav
      className="fixed top-0 w-full bg-black/90 backdrop-blur-md z-50 border-b border-[#00AEEF]/20"
      style={{ boxShadow: "0 0 20px rgba(0,174,239,0.2)" }}
    >
      <div className="max-w-7xl mx-auto px-4 sm:px-6 py-3 sm:py-4">
        <div className="flex items-center justify-between">
          {/* Logo */}
          <div className="flex items-center gap-2 flex-shrink-0">
            <div
              className="w-8 h-8 sm:w-10 sm:h-10 bg-gradient-to-br from-[#00AEEF] to-[#8A2BE2] rounded-xl flex items-center justify-center"
              style={{ boxShadow: "0 0 20px rgba(0,174,239,0.5)" }}
            >
              <Sparkles className="w-5 h-5 sm:w-6 sm:h-6 text-white" />
            </div>
            <span className="text-white text-lg sm:text-xl font-bold">Ainoxa</span>
          </div>

          {/* Desktop Navigation */}
          <div className="hidden lg:flex items-center gap-6 xl:gap-8">
            <div
              className="relative"
              onMouseEnter={() => setSolutionsOpen(true)}
              onMouseLeave={() => setSolutionsOpen(false)}
            >
              <button className="text-[#A3A3A3] hover:text-[#00AEEF] flex items-center gap-1 transition-colors text-sm">
                Solutions <ChevronDown className="w-4 h-4" />
              </button>
              {solutionsOpen && (
                <div
                  className="absolute top-full mt-2 bg-[#0A0A0A] rounded-lg p-4 min-w-[200px] border border-[#00AEEF]/30"
                  style={{ boxShadow: "0 0 30px rgba(0,174,239,0.3)" }}
                >
                  <a
                    href="#"
                    className="block px-4 py-2 text-[#A3A3A3] hover:text-[#00AEEF] hover:bg-[#00AEEF]/10 rounded transition-colors text-sm"
                  >
                    Custom AI Development
                  </a>
                  <a
                    href="#"
                    className="block px-4 py-2 text-[#A3A3A3] hover:text-[#00AEEF] hover:bg-[#00AEEF]/10 rounded transition-colors text-sm"
                  >
                    Process Automation
                  </a>
                  <a
                    href="#"
                    className="block px-4 py-2 text-[#A3A3A3] hover:text-[#00AEEF] hover:bg-[#00AEEF]/10 rounded transition-colors text-sm"
                  >
                    AI Chatbots
                  </a>
                </div>
              )}
            </div>
            <a href="#services" className="text-[#A3A3A3] hover:text-[#00AEEF] transition-colors text-sm">
              Services
            </a>
            <a href="#about" className="text-[#A3A3A3] hover:text-[#00AEEF] transition-colors text-sm">
              About
            </a>
            <a href="#case-studies" className="text-[#A3A3A3] hover:text-[#00AEEF] transition-colors text-sm">
              Case Studies
            </a>
            <a href="#contact" className="text-[#A3A3A3] hover:text-[#00AEEF] transition-colors text-sm">
              Contact
            </a>
          </div>

          {/* CTA Button - Hidden on mobile */}
          <button
            className="hidden sm:block border border-[#00AEEF] text-[#00AEEF] px-4 sm:px-6 py-2 rounded-lg hover:bg-[#00AEEF] hover:text-white transition-all text-sm"
            style={{ boxShadow: "0 0 20px rgba(0,174,239,0.3)" }}
          >
            Find Talent
          </button>

          {/* Mobile Menu Button */}
          <button onClick={() => setMobileMenuOpen(!mobileMenuOpen)} className="lg:hidden text-white p-2">
            {mobileMenuOpen ? <X className="w-6 h-6" /> : <Menu className="w-6 h-6" />}
          </button>
        </div>

        {/* Mobile Navigation */}
        {mobileMenuOpen && (
          <div className="lg:hidden mt-4 pb-4 space-y-3 border-t border-[#00AEEF]/20 pt-4">
            <a href="#services" className="block text-[#A3A3A3] hover:text-[#00AEEF] transition-colors text-sm py-2">
              Services
            </a>
            <a href="#about" className="block text-[#A3A3A3] hover:text-[#00AEEF] transition-colors text-sm py-2">
              About
            </a>
            <a
              href="#case-studies"
              className="block text-[#A3A3A3] hover:text-[#00AEEF] transition-colors text-sm py-2"
            >
              Case Studies
            </a>
            <a href="#contact" className="block text-[#A3A3A3] hover:text-[#00AEEF] transition-colors text-sm py-2">
              Contact
            </a>
            <button
              className="w-full border border-[#00AEEF] text-[#00AEEF] px-4 py-2 rounded-lg hover:bg-[#00AEEF] hover:text-white transition-all text-sm mt-2"
              style={{ boxShadow: "0 0 20px rgba(0,174,239,0.3)" }}
            >
              Find Talent
            </button>
          </div>
        )}
      </div>
    </nav>
  )
}
