import type React from "react"
import { Code, Smartphone, Database, Cloud, Palette, Brain, ArrowRight } from "lucide-react"

interface Talent {
  title: string
  subtitle: string
  skills: string[]
  icon: React.ComponentType<{ className?: string }>
  color: string
}

interface Service {
  title: string
  description: string
}

export default function ResourceManagement() {
  const talents: Talent[] = [
    {
      title: "Web Developers",
      subtitle: "Frontend, Backend & Full-Stack",
      skills: ["React", "Node.js", "Python", "JavaScript"],
      icon: Code,
      color: "from-blue-500 to-cyan-500",
    },
    {
      title: "Mobile Developers",
      subtitle: "iOS, Android & Cross-Platform",
      skills: ["React Native", "Flutter", "Swift", "Kotlin"],
      icon: Smartphone,
      color: "from-purple-500 to-pink-500",
    },
    {
      title: "Data Engineers",
      subtitle: "Big Data & Analytics",
      skills: ["Python", "SQL", "AWS", "Spark"],
      icon: Database,
      color: "from-green-500 to-emerald-500",
    },
    {
      title: "DevOps Engineers",
      subtitle: "Infrastructure & Automation",
      skills: ["Docker", "Kubernetes", "AWS", "Jenkins"],
      icon: Cloud,
      color: "from-orange-500 to-red-500",
    },
    {
      title: "UI/UX Designers",
      subtitle: "User Experience & Interface",
      skills: ["Figma", "Adobe XD", "Sketch", "Prototyping"],
      icon: Palette,
      color: "from-pink-500 to-rose-500",
    },
    {
      title: "AI/ML Engineers",
      subtitle: "Machine Learning & AI",
      skills: ["TensorFlow", "PyTorch", "Python", "NLP"],
      icon: Brain,
      color: "from-indigo-500 to-purple-500",
    },
  ]

  const services: Service[] = [
    {
      title: "Talent Sourcing",
      description: "Access our network of pre-vetted tech professionals",
    },
    {
      title: "Technical Assessment",
      description: "Comprehensive evaluation of skills and experience",
    },
    {
      title: "Rapid Deployment",
      description: "Quick onboarding and project integration",
    },
  ]

  return (
    <section id="careers" className="relative py-20 bg-black">
      <div className="max-w-7xl mx-auto px-6">
        {/* Section heading */}
        <h2 className="text-4xl md:text-5xl font-bold text-center mb-4">
          <span className="text-white">Resource Management</span>
        </h2>

        <p className="text-gray-400 text-center max-w-3xl mx-auto mb-16 text-lg">
          Connect with top-tier tech talent. Nenotechnology provides comprehensive recruitment solutions for companies
          seeking skilled developers, engineers, and designers across all technology domains.
        </p>

        {/* Core services */}
        <div className="mb-16">
          <h3 className="text-2xl font-bold text-white text-center mb-8">Our Core Services</h3>
          <p className="text-gray-400 text-center mb-8">
            Comprehensive talent acquisition solutions tailored to your business needs
          </p>
          <div className="grid grid-cols-1 md:grid-cols-3 gap-6">
            {services.map((service, index) => (
              <div
                key={index}
                className="bg-gradient-to-br from-gray-900/90 to-gray-900/50 border border-gray-800 rounded-2xl p-6 hover:border-blue-500/50 transition-all text-center"
              >
                <h4 className="text-xl font-bold text-white mb-2">{service.title}</h4>
                <p className="text-gray-400 text-sm">{service.description}</p>
              </div>
            ))}
          </div>
        </div>

        {/* Available talent */}
        <div className="mb-16">
          <h3 className="text-2xl font-bold text-white text-center mb-8">Available Tech Talent</h3>
          <p className="text-gray-400 text-center mb-8">
            Skilled professionals across all major technology domains and specializations
          </p>
          <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
            {talents.map((talent, index) => {
              const Icon = talent.icon
              return (
                <div key={index} className="group relative">
                  <div
                    className={`absolute inset-0 bg-gradient-to-r ${talent.color} rounded-2xl opacity-0 group-hover:opacity-20 blur-xl transition-opacity`}
                  ></div>
                  <div className="relative bg-gradient-to-br from-gray-900/90 to-gray-900/50 border border-gray-800 rounded-2xl p-6 hover:border-gray-700 transition-all">
                    <div
                      className={`w-12 h-12 bg-gradient-to-r ${talent.color} bg-opacity-20 rounded-xl flex items-center justify-center mb-4`}
                    >
                      <Icon className={`w-6 h-6 bg-gradient-to-r ${talent.color} bg-clip-text text-transparent`} />
                    </div>
                    <h4 className="text-xl font-bold text-white mb-1">{talent.title}</h4>
                    <p className="text-gray-400 text-sm mb-4">{talent.subtitle}</p>
                    <div className="flex flex-wrap gap-2 mb-6">
                      {talent.skills.map((skill, sIndex) => (
                        <span key={sIndex} className="px-3 py-1 bg-gray-800 text-gray-300 text-xs rounded-full">
                          {skill}
                        </span>
                      ))}
                    </div>
                    <button className="w-full flex items-center justify-center gap-2 bg-gray-800/50 hover:bg-gray-800 border border-gray-700 text-white px-4 py-3 rounded-lg transition-all group-hover:border-blue-500/50">
                      Contact Us <ArrowRight className="w-4 h-4" />
                    </button>
                  </div>
                </div>
              )
            })}
          </div>
        </div>

        {/* CTA */}
        <div className="bg-gradient-to-br from-blue-600/20 to-purple-600/20 border border-blue-500/30 rounded-3xl p-12 text-center">
          <h3 className="text-3xl font-bold text-white mb-4">Ready to Scale Your Team?</h3>
          <p className="text-gray-300 mb-8">
            Get access to our curated pool of tech talent. From junior developers to senior architects, we have the
            right fit for your project needs.
          </p>
          <div className="flex flex-wrap items-center justify-center gap-4">
            <button className="bg-white text-black px-8 py-4 rounded-lg font-semibold hover:bg-gray-200 transition-all hover:scale-105">
              Hire Now
            </button>
            <button className="border border-gray-600 text-white px-8 py-4 rounded-lg font-semibold hover:border-blue-500 hover:bg-blue-500/10 transition-all">
              Schedule Demo
            </button>
          </div>
        </div>
      </div>
    </section>
  )
}
