import type React from "react"
import {
  Brain,
  Sparkles,
  Bot,
  Cpu,
  FileText,
  BarChart3,
  Database,
  Zap,
  TrendingUp,
  CheckCircle2,
  ArrowRight,
} from "lucide-react"

interface Service {
  icon: React.ComponentType<{ className?: string }>
  color: string
  bgColor: string
  title: string
  description: string
  features: string[]
}

export default function Services() {
  const services: Service[] = [
    {
      icon: Brain,
      color: "#00AEEF",
      bgColor: "bg-[#00AEEF]/10",
      title: "AI Strategy Consultation",
      description:
        "Expert guidance on AI implementation strategies, technology selection, and digital transformation roadmaps for your business.",
      features: ["AI Readiness Assessment", "Technology Roadmap", "ROI Analysis", "Implementation Planning"],
    },
    {
      icon: Sparkles,
      color: "#8A2BE2",
      bgColor: "bg-[#8A2BE2]/10",
      title: "Business Process Automation",
      description: "Custom AI solutions that automate repetitive tasks and streamline your business workflows.",
      features: ["Process Analysis", "Custom Workflow Design", "Integration Development", "Performance Monitoring"],
    },
    {
      icon: Cpu,
      color: "#00AEEF",
      bgColor: "bg-[#00AEEF]/10",
      title: "Custom AI Solutions",
      description: "Tailored artificial intelligence systems designed to solve your specific business challenges.",
      features: ["Problem Analysis", "Custom AI Development", "Integration & Testing", "Ongoing Support"],
    },
    {
      icon: Bot,
      color: "#8A2BE2",
      bgColor: "bg-[#8A2BE2]/10",
      title: "AI-Powered Customer Support",
      description:
        "Intelligent chatbots and support systems that enhance customer experience and reduce response times.",
      features: [
        "Custom Chatbot Development",
        "Multi-channel Integration",
        "Analytics & Insights",
        "24/7 Availability",
      ],
    },
    {
      icon: TrendingUp,
      color: "#00AEEF",
      bgColor: "bg-[#00AEEF]/10",
      title: "Machine Learning Models",
      description:
        "Custom ML algorithms that learn from your data to predict trends, automate decisions, and optimize operations.",
      features: ["Predictive Analytics", "Pattern Recognition", "Automated Decision Making", "Model Optimization"],
    },
    {
      icon: FileText,
      color: "#8A2BE2",
      bgColor: "bg-[#8A2BE2]/10",
      title: "Intelligent Document Processing",
      description: "AI-powered document automation that extracts, processes, and analyzes business documents at scale.",
      features: ["OCR & Text Extraction", "Data Classification", "Automated Workflows", "Compliance Monitoring"],
    },
    {
      icon: BarChart3,
      color: "#00AEEF",
      bgColor: "bg-[#00AEEF]/10",
      title: "AI Data Analytics",
      description:
        "Transform raw business data into actionable insights with custom AI analytics and visualization tools.",
      features: ["Data Mining", "Business Intelligence", "Custom Dashboards", "Automated Reports"],
    },
    {
      icon: Database,
      color: "#8A2BE2",
      bgColor: "bg-[#8A2BE2]/10",
      title: "AI System Integration",
      description:
        "Seamlessly integrate AI capabilities into your existing systems and workflows for maximum efficiency.",
      features: ["API Development", "System Integration", "Legacy System Modernization", "Cloud Migration"],
    },
    {
      icon: Zap,
      color: "#00AEEF",
      bgColor: "bg-[#00AEEF]/10",
      title: "AI Performance Optimization",
      description:
        "Continuously monitor and optimize your AI systems for peak performance and maximum business impact.",
      features: ["Performance Monitoring", "Model Optimization", "Cost Reduction", "Scalability Planning"],
    },
  ]

  return (
    <section id="services" className="relative py-12 sm:py-16 md:py-20 bg-[#0A0A0A]">
      <div className="max-w-7xl mx-auto px-4 sm:px-6">
        {/* Section badge */}
        <div className="flex justify-center mb-6 sm:mb-8">
          <div
            className="inline-flex items-center gap-2 px-3 sm:px-4 py-2 rounded-full bg-[#00AEEF]/10 border border-[#00AEEF]/30 text-[#00AEEF] text-xs sm:text-sm"
            style={{ boxShadow: "0 0 20px rgba(0,174,239,0.3)" }}
          >
            <div
              className="w-2 h-2 bg-[#00AEEF] rounded-full animate-pulse"
              style={{ boxShadow: "0 0 10px rgba(0,174,239,0.8)" }}
            ></div>
            AI Services & Consultation
            <div
              className="w-2 h-2 bg-[#8A2BE2] rounded-full animate-pulse"
              style={{ boxShadow: "0 0 10px rgba(138,43,226,0.8)" }}
            ></div>
          </div>
        </div>

        {/* Section heading */}
        <h2 className="text-2xl sm:text-3xl md:text-4xl lg:text-5xl font-bold text-center mb-4 px-2">
          <span className="text-white">AI Automation Agency</span>
          <br />
          <span className="text-transparent bg-clip-text bg-gradient-to-r from-[#00AEEF] via-[#8A2BE2] to-[#00AEEF]">
            Transforming Businesses
          </span>
        </h2>

        <p className="text-[#A3A3A3] text-center max-w-3xl mx-auto mb-12 sm:mb-16 text-sm sm:text-base md:text-lg px-2">
          As a specialized AI agency, Ainoxa provides expert consultation and creates custom automation solutions that
          revolutionize how businesses operate. From strategic AI planning to intelligent chatbots and automated
          workflows, we guide and build AI systems that solve real business challenges.
        </p>

        {/* Services grid */}
        <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4 sm:gap-6">
          {services.map((service, index) => {
            const Icon = service.icon
            return (
              <div key={index} className="group relative">
                <div
                  className="absolute inset-0 rounded-2xl opacity-0 group-hover:opacity-100 blur-xl transition-opacity duration-500"
                  style={{
                    background: `linear-gradient(135deg, ${service.color}40, ${service.color}20)`,
                    boxShadow: `0 0 40px ${service.color}60`,
                  }}
                ></div>
                <div
                  className="relative bg-black/50 backdrop-blur-sm border rounded-2xl p-4 sm:p-6 hover:border-opacity-50 transition-all duration-300 h-full flex flex-col"
                  style={{ borderColor: `${service.color}40` }}
                >
                  {/* Icon */}
                  <div
                    className={`w-12 h-12 sm:w-14 sm:h-14 ${service.bgColor} rounded-2xl flex items-center justify-center mb-4 group-hover:scale-110 transition-transform duration-300`}
                    style={{ boxShadow: `0 0 20px ${service.color}40` }}
                  >
                    <Icon className="w-6 h-6 sm:w-7 sm:h-7" style={{ color: service.color }} />
                  </div>

                  {/* Title */}
                  <h3 className="text-lg sm:text-xl font-bold text-white mb-3">{service.title}</h3>

                  {/* Description */}
                  <p className="text-[#A3A3A3] text-xs sm:text-sm mb-4 leading-relaxed">{service.description}</p>

                  {/* Features */}
                  <ul className="space-y-2 mb-6 flex-grow">
                    {service.features.map((feature, fIndex) => (
                      <li key={fIndex} className="flex items-center gap-2 text-[#A3A3A3] text-xs sm:text-sm">
                        <CheckCircle2
                          className="w-3 h-3 sm:w-4 sm:h-4 flex-shrink-0"
                          style={{ color: service.color }}
                        />
                        <span>{feature}</span>
                      </li>
                    ))}
                  </ul>

                  {/* Learn More Button */}
                  <button
                    className="w-full flex items-center justify-center gap-2 bg-black/50 hover:bg-black border px-4 py-2 sm:py-3 rounded-lg transition-all text-sm"
                    style={{ borderColor: `${service.color}40`, boxShadow: `0 0 15px ${service.color}20` }}
                  >
                    <span style={{ color: service.color }}>Learn More</span>{" "}
                    <ArrowRight
                      className="w-3 h-3 sm:w-4 sm:h-4 group-hover:translate-x-1 transition-transform"
                      style={{ color: service.color }}
                    />
                  </button>
                </div>
              </div>
            )
          })}
        </div>
      </div>
    </section>
  )
}
