import type React from "react"
import { TrendingUp, Zap, Clock, GitBranch } from "lucide-react"

interface Stat {
  icon: React.ComponentType<{ className?: string }>
  value: string
  label: string
  color: string
}

export default function Stats() {
  const stats: Stat[] = [
    { icon: TrendingUp, value: "150+", label: "AI Solutions Delivered", color: "#00AEEF" },
    { icon: Zap, value: "95%", label: "Process Efficiency Gain", color: "#8A2BE2" },
    { icon: Clock, value: "24/7", label: "AI System Uptime", color: "#00AEEF" },
    { icon: GitBranch, value: "500+", label: "Business Workflows Automated", color: "#8A2BE2" },
  ]

  return (
    <section className="relative py-12 sm:py-16 md:py-20 bg-[#0A0A0A]">
      <div className="max-w-7xl mx-auto px-4 sm:px-6">
        <div className="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-4 sm:gap-6">
          {stats.map((stat, index) => {
            const Icon = stat.icon
            return (
              <div key={index} className="relative group">
                <div
                  className="absolute inset-0 rounded-2xl opacity-0 group-hover:opacity-100 blur transition-opacity"
                  style={{
                    background: `linear-gradient(135deg, ${stat.color}40, ${stat.color}20)`,
                    boxShadow: `0 0 30px ${stat.color}60`,
                  }}
                ></div>
                <div
                  className="relative bg-black/50 backdrop-blur-sm border rounded-2xl p-6 sm:p-8 text-center hover:border-opacity-50 transition-all"
                  style={{ borderColor: `${stat.color}40` }}
                >
                  <div className="flex justify-center mb-4">
                    <div
                      className="w-12 h-12 sm:w-16 sm:h-16 rounded-full flex items-center justify-center"
                      style={{
                        background: `linear-gradient(135deg, ${stat.color}, ${stat.color}80)`,
                        boxShadow: `0 0 30px ${stat.color}60`,
                      }}
                    >
                      <Icon className="w-6 h-6 sm:w-8 sm:h-8 text-white" />
                    </div>
                  </div>
                  <div
                    className="text-3xl sm:text-4xl md:text-5xl font-bold mb-2"
                    style={{ color: stat.color, textShadow: `0 0 20px ${stat.color}80` }}
                  >
                    {stat.value}
                  </div>
                  <div className="text-[#A3A3A3] text-xs sm:text-sm">{stat.label}</div>
                </div>
              </div>
            )
          })}
        </div>

        {/* Industry badges */}
        <div className="max-w-7xl mx-auto mt-12 sm:mt-16">
          <div className="flex flex-wrap justify-center gap-2 sm:gap-4">
            {["Manufacturing", "Healthcare", "E-commerce", "Finance", "Education"].map((industry, index) => (
              <span
                key={index}
                className="px-4 sm:px-6 py-2 bg-black/50 border border-[#00AEEF]/20 rounded-full text-[#A3A3A3] text-xs sm:text-sm hover:border-[#00AEEF]/50 hover:text-[#00AEEF] transition-all cursor-pointer"
              >
                {industry}
              </span>
            ))}
          </div>
        </div>
      </div>
    </section>
  )
}
