"use client"

import { useState } from "react"
import { ChevronLeft, ChevronRight } from "lucide-react"

interface Testimonial {
  quote: string
  author: string
  role: string
  company: string
  initials: string
}

export default function Testimonials() {
  const [currentIndex, setCurrentIndex] = useState(0)

  const testimonials: Testimonial[] = [
    {
      quote:
        "Nenotechnology's AI automation solution transformed our manufacturing process. The computer vision system catches defects we used to miss, and our production efficiency has increased dramatically.",
      author: "Kiran Shah",
      role: "Production Head",
      company: "Gujarat Manufacturing Co.",
      initials: "KS",
    },
    {
      quote:
        "The intelligent document processing system has revolutionized our loan approval process. What used to take days now happens in hours, with better accuracy than manual processing.",
      author: "Meera Joshi",
      role: "Digital Transformation Lead",
      company: "Ahmedabad FinTech Solutions",
      initials: "MJ",
    },
    {
      quote:
        "The AI-powered patient management system has significantly improved our operational efficiency. Our staff can now focus on patient care instead of administrative tasks.",
      author: "Dr. Vikram Patel",
      role: "Chief Medical Officer",
      company: "Rajkot Healthcare Network",
      initials: "DVP",
    },
    {
      quote:
        "The custom AI solution for inventory management has reduced our stockouts by 90% and improved customer satisfaction. The predictive analytics are incredibly accurate.",
      author: "Rajesh Kumar",
      role: "Operations Director",
      company: "Mumbai Retail Chain",
      initials: "RK",
    },
    {
      quote:
        "Nenotechnology's chatbot implementation has handled 80% of our customer queries automatically, freeing up our support team to focus on complex issues.",
      author: "Priya Sharma",
      role: "Customer Success Manager",
      company: "Delhi E-commerce Platform",
      initials: "PS",
    },
    {
      quote:
        "The AI-powered fraud detection system has saved us millions in potential losses. The accuracy and speed of detection is remarkable.",
      author: "Amit Desai",
      role: "Risk Management Head",
      company: "Pune Banking Solutions",
      initials: "AD",
    },
  ]

  const nextSlide = () => {
    setCurrentIndex((prev) => (prev + 1) % Math.ceil(testimonials.length / 3))
  }

  const prevSlide = () => {
    setCurrentIndex((prev) => (prev - 1 + Math.ceil(testimonials.length / 3)) % Math.ceil(testimonials.length / 3))
  }

  const displayedTestimonials = testimonials.slice(currentIndex * 3, currentIndex * 3 + 3)

  return (
    <section className="relative py-20 bg-[#0a0a0f]">
      <div className="max-w-7xl mx-auto px-6">
        {/* Section badge */}
        <div className="flex justify-center mb-6">
          <div className="inline-flex items-center gap-2 px-4 py-2 rounded-full bg-purple-500/10 border border-purple-500/30 text-purple-400 text-sm">
            Client Testimonials
          </div>
        </div>

        {/* Section heading */}
        <h2 className="text-4xl md:text-5xl font-bold text-center mb-4">
          <span className="text-white">What Our Clients Say</span>
        </h2>

        <p className="text-gray-400 text-center max-w-3xl mx-auto mb-16 text-lg">
          Hear from businesses that have transformed their operations with our AI automation solutions
        </p>

        {/* Testimonials grid */}
        <div className="grid grid-cols-1 md:grid-cols-3 gap-6 mb-8">
          {displayedTestimonials.map((testimonial, index) => (
            <div
              key={index}
              className="bg-gradient-to-br from-gray-900/90 to-gray-900/50 border border-gray-800 rounded-2xl p-6 hover:border-blue-500/50 transition-all"
            >
              <div className="mb-6">
                <p className="text-gray-300 leading-relaxed italic">{`"${testimonial.quote}"`}</p>
              </div>
              <div className="flex items-center gap-4">
                <div className="w-12 h-12 bg-gradient-to-r from-blue-500 to-purple-500 rounded-full flex items-center justify-center text-white font-bold">
                  {testimonial.initials}
                </div>
                <div>
                  <div className="text-white font-semibold">{testimonial.author}</div>
                  <div className="text-gray-400 text-sm">{testimonial.role}</div>
                  <div className="text-gray-500 text-xs">{testimonial.company}</div>
                </div>
              </div>
            </div>
          ))}
        </div>

        {/* Navigation */}
        <div className="flex items-center justify-center gap-4">
          <button
            onClick={prevSlide}
            className="w-12 h-12 bg-gray-800 hover:bg-gray-700 border border-gray-700 rounded-full flex items-center justify-center transition-all"
          >
            <ChevronLeft className="w-5 h-5 text-white" />
          </button>
          <div className="flex gap-2">
            {[...Array(Math.ceil(testimonials.length / 3))].map((_, index) => (
              <div
                key={index}
                className={`w-2 h-2 rounded-full transition-all ${
                  index === currentIndex ? "bg-blue-500 w-8" : "bg-gray-700"
                }`}
              />
            ))}
          </div>
          <button
            onClick={nextSlide}
            className="w-12 h-12 bg-gray-800 hover:bg-gray-700 border border-gray-700 rounded-full flex items-center justify-center transition-all"
          >
            <ChevronRight className="w-5 h-5 text-white" />
          </button>
        </div>
      </div>
    </section>
  )
}
