import type React from "react"
import { Zap, Target, TrendingUp, Shield } from "lucide-react"

interface Benefit {
  icon: React.ComponentType<{ className?: string }>
  title: string
  stat: string
  description: string
}

export default function WhyChooseUs() {
  const benefits: Benefit[] = [
    {
      icon: Zap,
      title: "Operational Efficiency",
      stat: "Less Manual Work",
      description: "AI automation reduces manual work by up to 80%, allowing your team to focus on strategic growth.",
    },
    {
      icon: Target,
      title: "Error Reduction",
      stat: "99.5% Accuracy",
      description: "Machine learning models provide consistent, accurate results with minimal human error.",
    },
    {
      icon: Shield,
      title: "24/7 AI Operations",
      stat: "Always Active",
      description: "Our AI systems work continuously, processing requests and automating tasks around the clock.",
    },
    {
      icon: TrendingUp,
      title: "Rapid ROI",
      stat: "300% ROI Average",
      description: "See measurable returns on your AI investment within weeks, not months or years.",
    },
  ]

  return (
    <section className="relative py-20 bg-gradient-to-br from-black via-purple-950/10 to-orange-950/10">
      <div className="max-w-7xl mx-auto px-6">
        {/* Section heading */}
        <div className="text-center mb-16">
          <h2 className="text-4xl md:text-5xl font-bold text-white mb-4">
            Why Partner with
            <span className="text-transparent bg-clip-text bg-gradient-to-r from-orange-400 via-pink-500 to-purple-600">
              {" "}
              Ainoxa?
            </span>
          </h2>
          <p className="text-gray-400 text-lg max-w-3xl mx-auto">
            We specialize exclusively in AI automation, bringing deep expertise in machine learning, natural language
            processing, and business process optimization to every project.
          </p>
        </div>

        {/* Benefits grid */}
        <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-16">
          {benefits.map((benefit, index) => {
            const Icon = benefit.icon
            const gradients = [
              "from-orange-500 to-pink-600",
              "from-pink-500 to-purple-600",
              "from-purple-500 to-pink-600",
              "from-red-500 to-orange-600",
            ]
            return (
              <div key={index} className="relative group">
                <div
                  className={`absolute inset-0 bg-gradient-to-r ${gradients[index]} rounded-2xl opacity-0 group-hover:opacity-100 blur-xl transition-opacity`}
                ></div>
                <div className="relative bg-gradient-to-br from-gray-900/90 to-gray-900/50 border border-orange-500/20 rounded-2xl p-6 hover:border-orange-500/50 transition-all">
                  <div
                    className={`w-12 h-12 bg-gradient-to-br ${gradients[index]} rounded-xl flex items-center justify-center mb-4 shadow-lg`}
                  >
                    <Icon className="w-6 h-6 text-white" />
                  </div>
                  <div
                    className={`text-2xl font-bold bg-gradient-to-r ${gradients[index]} bg-clip-text text-transparent mb-2`}
                  >
                    {benefit.stat}
                  </div>
                  <h3 className="text-lg font-bold text-white mb-2">{benefit.title}</h3>
                  <p className="text-gray-400 text-sm leading-relaxed">{benefit.description}</p>
                </div>
              </div>
            )
          })}
        </div>

        {/* CTA Section */}
        <div className="relative bg-gradient-to-br from-orange-600/20 via-pink-600/20 to-purple-600/20 border border-orange-500/30 rounded-3xl p-12 text-center overflow-hidden">
          <div className="absolute inset-0 bg-gradient-to-r from-orange-600/10 to-purple-600/10 rounded-3xl"></div>
          <div className="relative">
            <h3 className="text-3xl font-bold text-white mb-4">Ready to Transform Your Business?</h3>
            <p className="text-gray-300 mb-4">
              Join businesses across the globe that have already automated their operations and achieved measurable
              improvements with Ainoxa.
            </p>
            <div className="flex flex-wrap justify-center gap-4 mb-6">
              <div className="px-6 py-2 bg-gradient-to-r from-green-500/20 to-emerald-500/20 border border-green-500/30 rounded-lg text-green-400 text-sm">
                Free Consultation
              </div>
              <div className="px-6 py-2 bg-gradient-to-r from-orange-500/20 to-pink-500/20 border border-orange-500/30 rounded-lg text-orange-400 text-sm">
                Proof of Concept
              </div>
              <div className="px-6 py-2 bg-gradient-to-r from-purple-500/20 to-pink-500/20 border border-purple-500/30 rounded-lg text-purple-400 text-sm">
                Ongoing Support
              </div>
            </div>
            <div className="flex flex-wrap items-center justify-center gap-4">
              <button className="bg-gradient-to-r from-orange-500 via-pink-500 to-purple-600 text-white px-8 py-4 rounded-lg font-semibold hover:shadow-2xl hover:shadow-orange-500/50 transition-all hover:scale-105">
                Get Started
              </button>
              <button className="border border-orange-500 text-orange-400 px-8 py-4 rounded-lg font-semibold hover:bg-gradient-to-r hover:from-orange-500/10 hover:to-pink-500/10 transition-all">
                View ROI Calculator
              </button>
            </div>
            <p className="text-gray-400 text-sm mt-6">Trusted by 100+ businesses worldwide</p>
          </div>
        </div>
      </div>
    </section>
  )
}
